package kom.itbeankit.nw.ethernet;

import java.awt.*;
import kom.itbeankit.common.vcr.ClkEvent;
import kom.itbeankit.common.vcr.ClkListener;

public class SwitchElement extends java.awt.Container implements EthernetInterface,ClkListener
{
    protected int destPort=0,oben=0,unten=0,links=0,rechts=0;
	public SwitchElement()
	{
       
		//{{INIT_CONTROLS
		setLayout(new BorderLayout(0,0));
		setSize(104,20);
		panel = new java.awt.Panel();
		panel.setLayout(null);
		panel.setBounds(0,0,104,20);// 0,0,104,20
		panel.setBackground(new Color(12632256));
		add("Center", panel);
		label1 = new java.awt.Label("",Label.CENTER);
		label1.setBounds(27,17,50,15);
		label1.setFont(new Font("Dialog", Font.PLAIN, 12));
		panel.add(label1);
		//}}
		panel.setBackground(new Color(DATA_COLOR_IDLE));
		newStatus = new SwitchElementStatus();
		oldStatus = new SwitchElementStatus();
		dataType = DATA_TYPE_IDLE;
		dark = false;
	}
	//{{DECLARE_CONTROLS
	java.awt.Panel panel;
	java.awt.Label label1;
	//}}

    public void setDestPort(int dp){
        this.destPort=dp;}
    public void setLinks(int dp){
        this.links=dp;}
    public void setRechts(int dp){
        this.rechts=dp;}
    public void setOben(int dp){
        this.oben=dp;}
    public void setUnten(int dp){
        this.unten=dp;}
        
	public void paint(Graphics g){
	    super.paint(g);
	    panel.setSize(getSize());
	    panel.validate();
	}

    public void reset(){
        oldStatus = new SwitchElementStatus();
        newStatus = new SwitchElementStatus();
        dark = false;
    }
    
    
    public void clkReceived(ClkEvent e){
        //fire data events depending on old status
        //these events will change new status in listeners
        if(e.isRisingEdge()){
            processOldStatus();    
        }
        //copy new status in old status
        //and reset new status
        else{
            oldStatus.setStatus(newStatus);
            newStatus = new SwitchElementStatus();
        }
    }
    
    //sets datatype (and background color)
    //and fires events to neighbors
    // according to oldstatus
    private void processOldStatus(){
        setDataType(oldStatus.getDataType());
        setColor();
        for(int i=0; i<dataListeners.size();i++){
            
            DataListener dl = (DataListener)dataListeners.elementAt(i);
        
            if(oldStatus.fromLeftDataEvent != null){
                DataEvent de = new DataEvent(this,oldStatus.fromLeftDataEvent);
                switch (links){
                case 0:
                dl.dataToRight(de);         
                dl.dataToTop(de);         
                dl.dataToBottom(de);
                break;
                case 1:
                dl.dataToLeft(de);
                break;
                case 2:
                dl.dataToTop(de);
                break;
                case 3:
                dl.dataToBottom(de);
                break;
                case 4:
                dl.dataToRight(de);
                break;
                }
                oldStatus.fromLeftDataEvent = null;
            }
            if(oldStatus.fromRightDataEvent != null){
                DataEvent de = new DataEvent(this,oldStatus.fromRightDataEvent);
                switch (rechts){
                case 0:
                dl.dataToLeft(de);
                dl.dataToTop(de);         
                dl.dataToBottom(de); 
                 break;
                case 1:
                dl.dataToLeft(de);
                break;
                case 2:
                dl.dataToTop(de);
                break;
                case 3:
                dl.dataToBottom(de);
                break;
                case 4:
                dl.dataToRight(de);
                break;
                }
                oldStatus.fromRightDataEvent = null;
            }
            if(oldStatus.fromTopDataEvent != null){
                DataEvent de = new DataEvent(this,oldStatus.fromTopDataEvent);
                switch (oben){
                case 0:
                dl.dataToRight(de);         
                dl.dataToLeft(de);         
                dl.dataToBottom(de);
                 break;
                case 1:
                dl.dataToLeft(de);
                break;
                case 2:
                dl.dataToTop(de);
                break;
                case 3:
                dl.dataToBottom(de);
                break;
                case 4:
                dl.dataToRight(de);
                break;
                }
                oldStatus.fromTopDataEvent = null;
            }
            if(oldStatus.fromBottomDataEvent != null){
                DataEvent de = new DataEvent(this,oldStatus.fromBottomDataEvent);
                switch (unten){
                case 0:
                dl.dataToRight(de);         
                dl.dataToTop(de);         
                dl.dataToLeft(de);
                break;
                case 1:
                dl.dataToLeft(de);
                break;
                case 2:
                dl.dataToTop(de);
                break;
                case 3:
                dl.dataToBottom(de);
                break;
                case 4:
                dl.dataToRight(de);
                break;
                }
                oldStatus.fromBottomDataEvent = null;
            }
        }
    
    }

    public synchronized void addDataListener(DataListener lis)
    {
        dataListeners.addElement(lis);
    }
    
    public synchronized void removeDataListener(DataListener lis)
    {
        dataListeners.removeElement(lis);
    }
    
   /* protected void processDataEvent(DataEvent e)
    {
    }*/

   
   
   public void dataFromRight(DataEvent e){
         if(newStatus.fromRightDataEvent!=null)
            e = new DataEvent(this,DATA_TYPE_COLLISION,0,0,0,false,false);
        newStatus.fromRightDataEvent=e;
    }

    public void dataFromLeft(DataEvent e){
         if(newStatus.fromLeftDataEvent!=null)
            e = new DataEvent(this,DATA_TYPE_COLLISION,0,0,0,false,false);
        newStatus.fromLeftDataEvent=e;
    }

    public void dataFromTop(DataEvent e){
         if(newStatus.fromTopDataEvent!=null)
             e = new DataEvent(this,DATA_TYPE_COLLISION,0,0,0,false,false);
        newStatus.fromTopDataEvent=e;
    }
    
    public void dataFromBottom(DataEvent e){
         if(newStatus.fromBottomDataEvent!=null)
             e = new DataEvent(this,DATA_TYPE_COLLISION,0,0,0,false,false);
        newStatus.fromBottomDataEvent=e;
    }
   
    private void setColor(){
		//if (!((this.dataType==dataType)&&(this.dataType==DATATYPE_IDLE)))
		{
			int colorCode = 0;
			//set the background color according to data type
			if(dark){
    			switch(dataType){
    			    case DATA_TYPE_IDLE:
    		            colorCode = DATA_COLOR_IDLE;
    		            break;
    			    case DATA_TYPE_DATA:
    		            colorCode = DATA_COLOR_DATA_DARK;
    		            break;
    			    case DATA_TYPE_PADDING:
    		            colorCode = DATA_COLOR_PADDING_DARK;
    		            break;
    			    case DATA_TYPE_COLLISION:
    		            colorCode = DATA_COLOR_COLLISION_DARK;
    		            break;
    			    default:
    			}
			}
			else{
    			switch(dataType){
    			    case DATA_TYPE_IDLE:
    		            colorCode = DATA_COLOR_IDLE;
    		            break;
    			    case DATA_TYPE_DATA:
    		            colorCode = DATA_COLOR_DATA;
    		            break;
    			    case DATA_TYPE_PADDING:
    		            colorCode = DATA_COLOR_PADDING;
    		            break;
    			    case DATA_TYPE_COLLISION:
    		            colorCode = DATA_COLOR_COLLISION;
    		            break;
    			    default:
    			}
			}
			    
		    panel.setBackground(new Color(colorCode));
		}
    }
	
	public void setDataType(int dataType)
	{
        //int oldValue = this.dataType;
        //int newValue = dataType;
        if(dataType!=DATA_TYPE_IDLE)
            dark = !dark;
        this.dataType = dataType;
        //changes.firePropertyChange("dataType" ,oldValue, newValue);
	}
	

	public int getDataType()
	{
		return this.dataType;
	}


    public String getTheLabel(){
        return theLabel;   
    }
    
    public void setTheLabel(String st){
        label1.setText(st); 
    }

	static public void main(String args[])
	{
		class DriverFrame extends java.awt.Frame {
			public DriverFrame() {
				addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent event)
					{
						dispose();	  // free the system resources
						System.exit(0); // close the application
					}
				});
				this.setLayout(new java.awt.BorderLayout());
				this.setSize(300,300);
				this.add(new SwitchElement());
			}
		}

		new DriverFrame().show();
	}

	private symantec.itools.beans.PropertyChangeSupport changes = new symantec.itools.beans.PropertyChangeSupport(this);
	protected int dataType;
    protected boolean dark;
    protected SwitchElementStatus newStatus;
    protected SwitchElementStatus oldStatus;
    private java.util.Vector dataListeners = new java.util.Vector();
    private String theLabel = new String("Switch");

}